﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected class ClassEditBasePanel : AdminPanel
        {
            public ClassEditBasePanel(Administration Component) : base(Component) { }

            private BL.BO.Class _class = null;
            protected BL.BO.Class Class
            {
                get
                {
                    if (_class == null)
                    {
                        if (ClassID.HasValue && ClassID > 0)
                        {
                            _class = Component.BLELearning.Class.RestoreById(ClassID);
                        }
                        else
                        {
                            _class = Component.BLELearning.Class.New();
                            if (Component.Instructor != null)
                            {
                                _class.SchoolID = Component.Instructor.SchoolID;
                                _class.InstructorID = Component.Instructor.ID;
                            }
                        }
                    }
                    return _class;
                }
            }

            public override void Load()
            {
                if (Class != null && Component.Instructor != null)
                {
                    Component.AppendToXML(Class);
                    Component.AppendToXML(Component.BLELearning.School.Restore(Class.SchoolID));
                }
            }

            public override bool Save()
            {
                if (Component.Instructor != null)
                {
                    switch (EditMode)
                    {
                        case EditModeType.EditOrInsert:
                            Class.Name = Component.Environment.GetRequestParamString("Class_Name");
                            Component.MethodResult.Add(Component.BLELearning.Class.Save(Class));
                            Component.AdministrationArea = AdministrationAreaType.ClassEdit;
                            break;
                        case EditModeType.Remove:
                            if (Class != null && Class.ID.HasValue)
                            {
                                Component.MethodResult.Add(Component.BLELearning.Class.Remove(Class));
                                Component.AdministrationArea = AdministrationAreaType.ClassList;
                            }
                            break;
                        case EditModeType.GenerateCertificate:
                            if (Class != null && Class.ID.HasValue)
                            {
                                PI.ZB.N1200.ELearning.BL.PDFReport.GenerateClassCert(Class, Component.Environment);
                            }
                            break;
                    }
                }
                return Component.MethodResult.Success;
            }
        }
    }
}